// ============================================================================
// ============================================================================
// ============================================================================
// ==                                                                        ==
// == Name    : TheEmuLib.Emu_Clamp_RGBA.fsh                                 ==
// == Type    : Fragment shader                                              ==
// == Version : 1.0.2 (2017/04/102)                                           ==
// == Creator : TheEmu © TheEmu 2017, Some Rights Reserved                   ==
// == Licence : Creative Commons Attribution-ShareAlike 4.0                  ==
// ==           http://creativecommons.org/licences/by-sa/4.0                ==
// ==                                                                        ==
// == Purpose: To clamp an image's colour and opacity.                       ==
// ==                                                                        ==
// == Description: The values of the red, green, blue and alpha channels for ==
// == an image are clamped to ranges passed as parameters to the shader.     ==
// ==                                                                        ==
// == This file is a member of The Emu's shader library.                     ==
// ==                                                                        ==
// == ====================================================================== ==
// ==                                                                        ==
// == This shader was created because it was found that if a framebuffer was ==
// == used in an iStripper scene to overlay two sprites, such as one used as ==
// == a background image and a second used as a foreground element, and then ==
// == processing the combined images by a shader in a second framebuffer the ==
// == result was often marred because although the original  background  was ==
// == fully opaque, alpha=1.0 throughout, the combined image often had areas ==
// == for which alpha was not 1.0.  In the scene for which this misbehaviour ==
// == was first seen the result was to blow holes in the shader's output. It ==
// == is assumed that this is a general feature,  not  something specific to ==
// == the particular combination of images and shader usage.  I suspect that ==
// == something in the iStripper system makes the assumption that things are ==
// == either fully transparent or fully opaque which may well have been true ==
// == for the original system.  The  problem could be worked round by having ==
// == the shader that processes the combined images set alpha to 1.0 when it ==
// == samples the image, which is OK for a special purpose shader, but it is ==
// == not an appropriate solution for all the general purpose shaders  found ==
// == in TheEmuLib. Adding a control parameter to each shader in the library ==
// == to optionaly enable forcing the alpha value was also rejected as being ==
// == inappropriate for the library's shaders,  though some will have such a ==
// == a parameter, e.g. when the normal operation of the shader could result ==
// == in colour components going out of range.  This  shader provides a more ==
// == general solution and may even be occasionly useful in is own right.    ==
// ==                                                                        ==
// == ====================================================================== ==
// ==                                                                        ==
// == Update history:                                                        ==
// ==                                                                        ==
// ==   2016/12/16 - v1.0.0 - Initial version                                ==
// ==   2017/02/13 - v1.0.1 - Corrected spelling for normalisation function. ==
// ==   2017/04/02 - v1.0.2 - Minor update to initial comments.              ==
// ==                                                                        ==
// ============================================================================
// ============================================================================
// ============================================================================

// ============================================================================
// == Standard shader inputs ==================================================
// ============================================================================

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The image that is to be manipulated.

uniform sampler2D iChannel0;

// ============================================================================
// == Imports from TheEmuLib ==================================================
// ============================================================================
//
// The GLSL shader language currently provides no mechanism for importing  any
// elements that are defined in other modules, not even C's crude source level
// #include mechanism. In the absence of anything better TheEmuLib handles any
// imports by manualy copying relevent utility code snippets from the  sources
// in the Shader Lib.Inc directory. This is very crude but I have attempted to
// be systematic in the way in which this is presented in the library sources.
//
// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

// Macros from TheEmuLib.Emu_Common_Utilities.lib.src

#define EMU_DEFAULT(type,x,default_value) ( (x==type(0.0)) ? (default_value) : (x) )

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

// Functions from TheEmuLib.Emu_Coordinate_Normalisation.lib.src

vec2 Emu_Normalise_to_Window ( vec2 xy ) { return xy / u_WindowSize.xy; }

// ============================================================================
// == Shader specific inputs ==================================================
// ============================================================================

uniform vec2 Emu_Clamp_RGBA_range_r;
uniform vec2 Emu_Clamp_RGBA_range_g;
uniform vec2 Emu_Clamp_RGBA_range_b;
uniform vec2 Emu_Clamp_RGBA_range_a;

vec2 range_r = EMU_DEFAULT ( vec2, Emu_Clamp_RGBA_range_r, vec2(0.0,1.0) );
vec2 range_g = EMU_DEFAULT ( vec2, Emu_Clamp_RGBA_range_g, vec2(0.0,1.0) );
vec2 range_b = EMU_DEFAULT ( vec2, Emu_Clamp_RGBA_range_b, vec2(0.0,1.0) );
vec2 range_a = EMU_DEFAULT ( vec2, Emu_Clamp_RGBA_range_a, vec2(0.0,1.0) );

// ============================================================================
// == The shader's main routine ===============================================
// ============================================================================

void main ( void )
 {
   // Get the normalised coordinates of the current point.

   vec2 uv = Emu_Normalise_to_Window ( gl_FragCoord.xy );

   // Look up the corresponding colour in the source image.

   vec4 colour = texture2D ( iChannel0, uv );

   // Limit the components to the specified ranges.

   colour.r = clamp ( colour.r, range_r[0], range_r[1] );
   colour.g = clamp ( colour.g, range_g[0], range_g[1] );
   colour.b = clamp ( colour.b, range_b[0], range_b[1] );
   colour.a = clamp ( colour.a, range_a[0], range_a[1] );

   // Update shader outputs

   gl_FragColor = colour * gl_Color;

}